/////////////////////////////////////////////////////////////////////////////////

// Flame shader - obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

// Explicit inputs

uniform float u_Elapsed;   // The elapsed time in seconds
uniform vec2 u_WindowSize; // Window dimensions in pixels

// Implicit inputs
//    gl_FragCoord
//
// Outputs 
//    gl_FragColor

/////////////////////////////////////////////////////////////////////////////////

// If the display is jerky then reduce the value for ITERATIONS. This will
// reduce the calcultions needed for each pixel, but at the expense of the
// quality of the flame.

#define ITERATIONS 32
#define PI 3.1415926535897932384626433832795
/////////////////////////////////////////////////////////////////////////////////

float noise(vec3 p) //Thx to Las^Mercury
{
	vec3 i = floor(p);
	vec4 a = dot(i, vec3(1., 57., 21.)) + vec4(0., 57., 21., 78.);
	vec3 f = cos((p-i)*PI)*(-.5)+.5;
	a = mix(sin(cos(a)*a),sin(cos(1.+a)*(1.+a)), f.x);
	a.xy = mix(a.xz, a.yw, f.y);
	return mix(a.x, a.y, f.z);
}

float sphere(vec3 p, vec4 spr)
{
	return length(spr.xyz-p) - spr.w;
}

float flame(vec3 p)
{
	float d = sphere(p*vec3(1.,.5,1.), vec4(-1.0,-0.6,.0,2.));
	return d + (noise(p+vec3(.0,u_Elapsed*2.,.0)) + noise(p*6.)*.1)*.55*(p.y) ;
}

float scene(vec3 p)
{
	return min(100.-length(p) , abs(flame(p)) );
}

vec4 raymarch(vec3 org, vec3 dir)
{
	float d = 0.0, glow = 0.0, eps = 0.02;
	vec3  p = org;
	bool glowed = false;
	
	for(int i=0; i<ITERATIONS; i++)
	{
		d = scene(p) + eps;
		p += d * dir;
		if( d>eps )
		{
			if(flame(p) <.0)
				glowed=true;
			if(glowed)
       			glow = float(i)/32;
		}
	}
	return vec4(p,glow);
}

void main()
{
	vec2 v = -1.0 + 2.0 * gl_FragCoord.xy / u_WindowSize.xy;
	v.x *= u_WindowSize.x/u_WindowSize.y;
	
	vec3 org = vec3(0., -2., 4.);
	vec3 dir = normalize(vec3(v.x*1.6, -v.y, -1.5));
	
	vec4 p = raymarch(org, dir);
	float glow = p.w;
	
	vec4 col = mix(vec4(1.,.5,.1,1.), vec4(0.1,.5,1.,1.), p.y*.02+.4);
	
	gl_FragColor = mix(vec4(0.), col, pow(glow*2.,4.));
	//gl_FragColor = mix(vec4(1.), mix(vec4(1.,.5,.1,1.),vec4(0.1,.5,1.,1.),p.y*.02+.4), pow(glow*2.,4.));

}

